#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <time.h>

#define brVozilaSever 5
#define brVozilaJug 5

int severNaMostu = 0;
int jugNaMostu = 0;
int autobusNaMostuSever = 0;
int autobusNaMostuJug = 0;
int kamionNaMostuSever = 0;
int kamionNaMostuJug = 0;

pthread_mutex_t mutex;
pthread_cond_t condSever;
pthread_cond_t condJug;

void *workSever(void *arg) {
    long id = (long) arg;
    int tipVozila = rand() % 3; // 0 - automobil, 1 - autobus, 2 - kamion

    sleep(rand() % 5);
    if (tipVozila == 0) { // automobil
        printf("Vozilo %ld tipa AUTOMOBIL prilazi mostu sa SEVER strane\n", id);
        pthread_mutex_lock(&mutex);

        while (jugNaMostu > 0 || kamionNaMostuSever > 0) {
            pthread_cond_wait(&condSever, &mutex);
        }

        severNaMostu++;
        pthread_mutex_unlock(&mutex);

        printf("Vozilo %ld tipa AUTOMOBIL, dosao sa SEVER strane, se nalazi na mostu\n", id);
        sleep(1);

        printf("Vozilo %ld tipa AUTOMOBIL, dosao sa SEVER strane, je preslo most\n", id);
        pthread_mutex_lock(&mutex);
        severNaMostu--;
        if (severNaMostu == 0) {
            pthread_cond_broadcast(&condSever);
        }
        pthread_mutex_unlock(&mutex);

    } 
    else if (tipVozila == 1) { // autobus
        printf("Vozilo %ld tipa AUTOBUS prilazi mostu sa SEVER strane\n", id);
        pthread_mutex_lock(&mutex);

        while (jugNaMostu > 0 || kamionNaMostuSever > 0 || autobusNaMostuSever > 0) {
            pthread_cond_wait(&condSever, &mutex);
        }

        severNaMostu++;
        autobusNaMostuSever++;
        pthread_mutex_unlock(&mutex);

        printf("Vozilo %ld tipa AUTOBUS, dosao sa SEVER strane, se nalazi na mostu\n", id);
        sleep(3);

        printf("Vozilo %ld tipa AUTOBUS, dosao sa SEVER strane, je preslo most\n", id);
        pthread_mutex_lock(&mutex);
        severNaMostu--;
        autobusNaMostuSever--;

        if (severNaMostu == 0 || autobusNaMostuSever) {
            pthread_cond_broadcast(&condSever);
        }
        pthread_mutex_unlock(&mutex);

    } 
    else { // kamion
        printf("Vozilo %ld tipa KAMION prilazi mostu sa SEVER strane\n", id);
        pthread_mutex_lock(&mutex);

        while (jugNaMostu > 0 || kamionNaMostuSever > 0 || autobusNaMostuSever > 0) {
            pthread_cond_wait(&condSever, &mutex);
        }

        severNaMostu++;
        kamionNaMostuSever++;
        pthread_mutex_unlock(&mutex);

        printf("Vozilo %ld tipa KAMION, dosao sa SEVER strane, se nalazi na mostu\n", id);
        sleep(3);

        printf("Vozilo %ld tipa KAMION, dosao sa SEVER strane, je preslo most\n", id);
        pthread_mutex_lock(&mutex);
        severNaMostu--;
        kamionNaMostuSever--;
        if (severNaMostu == 0 || kamionNaMostuSever == 0) {
            pthread_cond_broadcast(&condSever);
        }
        pthread_mutex_unlock(&mutex);

    }
    return NULL;
}

void *workJug(void *arg) {
    long id = (long) arg;
    int tipVozila = rand() % 3; // 0 - automobil, 1 - autobus, 2 - kamion

    sleep(rand() % 5);
    if (tipVozila == 0) { // automobil
        printf("Vozilo %ld tipa AUTOMOBIL prilazi mostu sa JUG strane\n", id);
        pthread_mutex_lock(&mutex);

        while (severNaMostu > 0 || kamionNaMostuJug > 0) {
            pthread_cond_wait(&condSever, &mutex);
        }

        jugNaMostu++;
        pthread_mutex_unlock(&mutex);

        printf("Vozilo %ld tipa AUTOMOBIL, dosao sa JUG strane, se nalazi na mostu\n", id);
        sleep(3);

        printf("Vozilo %ld tipa AUTOMOBIL, dosao sa JUG strane, je preslo most\n", id);
        pthread_mutex_lock(&mutex);
        jugNaMostu--;
        if (jugNaMostu == 0) {
            pthread_cond_broadcast(&condSever);
        }
        pthread_mutex_unlock(&mutex);

    } 
    else if (tipVozila == 1) { // autobus
        printf("Vozilo %ld tipa AUTOBUS prilazi mostu sa JUG strane\n", id);
        pthread_mutex_lock(&mutex);

        while (severNaMostu > 0 || kamionNaMostuJug > 0 || autobusNaMostuJug > 0) {
            pthread_cond_wait(&condSever, &mutex);
        }

        jugNaMostu++;
        autobusNaMostuJug++;
        pthread_mutex_unlock(&mutex);

        printf("Vozilo %ld tipa AUTOBUS, dosao sa JUG strane, se nalazi na mostu\n", id);
        sleep(3);

        printf("Vozilo %ld tipa AUTOBUS, dosao sa JUG strane, je preslo most\n", id);
        pthread_mutex_lock(&mutex);
        jugNaMostu--;
        autobusNaMostuJug--;

        if (jugNaMostu == 0 || autobusNaMostuJug) {
            pthread_cond_broadcast(&condSever);
        }
        pthread_mutex_unlock(&mutex);
    } 
    else { // kamion
        printf("Vozilo %ld tipa KAMION prilazi mostu sa JUG strane\n", id);
        pthread_mutex_lock(&mutex);

        while (severNaMostu > 0 || kamionNaMostuJug > 0 || autobusNaMostuJug > 0) {
            pthread_cond_wait(&condSever, &mutex);
        }

        jugNaMostu++;
        kamionNaMostuJug++;
        pthread_mutex_unlock(&mutex);

        printf("Vozilo %ld tipa KAMION, dosao sa JUG strane, se nalazi na mostu\n", id);
        sleep(3);

        printf("Vozilo %ld tipa KAMION, dosao sa JUG strane, je preslo most\n", id);
        pthread_mutex_lock(&mutex);
        jugNaMostu--;
        kamionNaMostuJug--;
        if (jugNaMostu == 0 || kamionNaMostuJug) {
            pthread_cond_broadcast(&condSever);
        }
        pthread_mutex_unlock(&mutex);
    }
    return NULL;
}

int main() {
    srand(time(NULL));

    pthread_t threads[brVozilaSever + brVozilaJug];
    pthread_mutex_init(&mutex, NULL);
    pthread_cond_init(&condSever, NULL);
    pthread_cond_init(&condJug, NULL);

    for(long i = 0; i < brVozilaSever; i++) {
        pthread_create(&threads[i], NULL, workSever, (void *) i);
    }

    for(long i = 0; i < brVozilaJug; i++) {
        pthread_create(&threads[brVozilaSever + i], NULL, workJug, (void *) i);
    }

    for(int i = 0; i < brVozilaSever + brVozilaJug; i++) {
        pthread_join(threads[i], NULL);
    }

    pthread_mutex_destroy(&mutex);
    pthread_cond_destroy(&condSever);
    pthread_cond_destroy(&condJug);

    return 0;
}